require( "quest/m1_intersection/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		
		local lastScene = game:GetLastScene();
		
		if lastScene == "m1_beauty" then
			scene.DOOR:PlayAnim("Opened");
			actor:JumpToNamedPoint("beauty");
			actor:FaceNow(DIR.E);
			actor:WalkTo("flo");
			delay(3);
			scene.DOOR:PlayAnim("Close");
		elseif lastScene == "m1_spendalot1" then
			actor:JumpToNamedPoint("spendalot");
			actor:FaceNow(DIR.E);
		elseif lastScene == "m1_spendalot2" then
			actor:JumpToNamedPoint("spendalot3");
			actor:FaceNow(DIR.W);
		else -- lastScene == m1_florida
			actor:JumpToNamedPoint("florida");
			actor:Face(DIR.S);
		end
		
		actor:WalkTo("flo");
		wait_walkto();
		actor:Face(DIR.S);
		
		if game:Get("first_time_m1_interesection") < 1 then
			run_super_conversation(actor, "conv_m1_intersection_intro");
			game:Set("first_time_m1_interesection", 1);
		end
		
		spawn_nav_arrow(to_beauty_spec);
		
		actor:SetMode(MODE.FOLLOWCLICKS);
		
		--actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	end;
	
	on_arrive = function(flo1, flo2)
		if game:Get("first_time_m1_spendalot2") < 1 then
			convproc("FLO", "quip_flo_intersection_A");
		elseif game:Get("first_time_m1_spendalot1") < 1 then
			convproc("FLO", "quip_flo_intersection_B");
		else
			convproc("FLO", "quip_flo_general");
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function lookat_office(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_look_at_wedding_planning_office");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

office_spec = 
{
	name = "OFFICE";
	halo = "office";
	
	command = function(actor)
		actor:SetDepthValue(200);
	end;
	
	on_arrive = function(flo, actor)
		--flo:FaceActor(actor);
		flo:StartProc(lookat_office);
	end;
}

function gotoflorida(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.TO_BEAUTY:Expire();
	--flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("florida");
	wait_walkto();
	goto_scene(flo, "m1_florida", true);
end

to_florida_spec = 
{
	name = "TO_FLORIDA";
	halo = "to_florida";
	cursor = "cursor_arrow_sw";
	goto_fn = gotoflorida;
}

function gotoeast(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.TO_BEAUTY:Expire();
	--flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("spendalot3");
	--scene.CAMERA:WalkTo("florida");
	wait_walkto();
	goto_scene(flo, "m1_spendalot2", true);
end

to_east_spec = 
{
	name = "TO_EAST";
	halo = "to_east";
	cursor = "cursor_arrow_e";
	goto_fn = gotoeast;
}

function gotowest(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.TO_BEAUTY:Expire();
	--flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("spendalot");
	--scene.CAMERA:WalkTo("florida");
	wait_walkto();
	goto_scene(flo, "m1_spendalot1", true);
end

to_west_spec = 
{
	name = "TO_WEST";
	halo = "to_west";
	cursor = "cursor_arrow_w";
	goto_fn = gotowest;
}

function gotobeauty(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if game:Get("module_progress") < 3 then
		scene.TO_BEAUTY:SetMode(MODE.CUTSCENE);
		flo:WalkTo("beauty");
		wait_walkto();
		
		goto_scene(flo, "m1_beauty");
	else
		run_super_conversation(flo, "quip_shop_closed");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

to_beauty_spec = 
{
	name = "TO_BEAUTY";
	halo = "beauty_door";
	cursor = "cursor_arrow_n";
	goto_fn = gotobeauty;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE and game:Get("module_progress") < 3 then
			if enter then
				scene.DOOR:PlayAnim("Open");
			else
				scene.DOOR:PlayAnim("Close");
			end
		end
	end;
}

door_spec =
{
	name = "DOOR";
	gfx = {anim = "anim/m1_intersection/door"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("1");
	end
}

beauty_salon_sign2_spec = 
{
	name = "BEAUTY_SALON_SIGN2";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/giddyup_std.mvec",
			color = { a = 1, r = 0.3, g = 0.18, b = 0.42 },
			outline_size = 0,
			lineheight = 40,
			linepadding = -12,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_beauty_salon_sign");
		actor:StopWalking();
		actor:SetPolygon({x=-199,y=-7}, {x=-293,y=-11}, {x=-213,y=-92}, {x=-293,y=-98});
		actor:TextToImage(10, 10);
	end;
}

beauty_salon_sign_spec = 
{
	name = "BEAUTY_SALON_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/giddyup_std.mvec",
			color = { a = 1, r = 0.3, g = 0.18, b = 0.42 },
			outline_size = 0,
			lineheight = 40,
			linepadding = -12,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_beauty_salon_sign");
		actor:StopWalking();
		actor:SetPolygon({x=199,y=7}, {x=293,y=11}, {x=213,y=92}, {x=293,y=98});
		actor:TextToImage(10, 10);
	end;
}

other_store_sign_spec = 
{
	name = "OTHER_STORE_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/giddyup_std.mvec",
			color = { a = 1, r = 0.98, g = 0.93, b = 1.0 },
			outline_size = 0,
			lineheight = 35,
			linepadding = -7,
		}
		
		actor:SetAlpha(1);
		
		actor:Say("text_other_store_sign");
		actor:StopWalking();
		actor:SetPolygon({x=580,y=60}, {x=680,y=71}, {x=591,y=109}, {x=690,y=117});
		actor:TextToImage(10, 10);
	end;
}

spendalot_st_sign_spec = 
{
	name = "SPENDALOT_ST_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 11,
		}
		
		actor:Say("text_spendalot_st_sign");
		actor:StopWalking();
		actor:SetPolygon({x=416,y=314}, {x=510,y=334}, {x=414,y=327}, {x=511,y=346});
		actor:TextToImage(0, 0);
	end;
}

florida_ave_sign_spec = 
{
	name = "FLORIDA_AVE_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 30,
		}
		
		actor:Say("text_florida_ave_sign");
		actor:StopWalking();
		actor:SetPolygon({x=347,y=351}, {x=407,y=312}, {x=349,y=365}, {x=409,y=322});
		actor:TextToImage(16, 0);
	end;
}

stop_sign_left_spec = 
{
	name = "STOP_SIGN_LEFT";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
		}
		
		actor:Say("text_stop_sign");
		actor:StopWalking();
		actor:SetPolygon({x=400,y=341}, {x=428,y=343}, {x=403,y=358}, {x=432,y=362});
		actor:TextToImage(0, 0);
	end;
}

stop_sign_right_spec = 
{
	name = "STOP_SIGN_RIGHT";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 14,
		}
		
		actor:Say("text_stop_sign");
		actor:StopWalking();
		actor:SetPolygon({x=675,y=192}, {x=699,y=176}, {x=673,y=210}, {x=697,y=195});
		actor:TextToImage(0, 0);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/walkingmusic.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		scene:SetRoomScale(150, 550, 0.45, 0.8);	--topline, bottomline, topscale, bottomscale
		
		local no_fade = game:GetLastScene() ~= "m1_beauty";
		fade_scene_up(false, no_fade);
		
		if IsCheatMode() then
			-- testing data
			--BAG_INV:AddInventory(inv_desc_token);
			--complete_quest("wedding_dress", false);
			--complete_quest("find_snookums", false);
		end
		
		spawn_nav_arrow(to_florida_spec);
		spawn_nav_arrow(to_east_spec);
		spawn_nav_arrow(to_west_spec);
		
		game:SetString("map_position", "m1_beauty");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "hydrant", 235 },
		{ "mailbox_and_light", 270 },
		{ "car_and_sign", 360 },
		{ "corner_building", 350 },
		{ "plant_mask", 370 },
		{ "tree", 600 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		office_spec,
		door_spec,
		
		flo_spec, -- the main actor
		
		scene_setup,
		
		beauty_salon_sign2_spec,
		beauty_salon_sign_spec,
		other_store_sign_spec,
		spendalot_st_sign_spec,
		florida_ave_sign_spec,
		stop_sign_left_spec,
		stop_sign_right_spec,
	};
};
